package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Win32LobAppRestartBehavior implements Enum {

    @JsonProperty("basedOnReturnCode")
    BASED_ON_RETURN_CODE("basedOnReturnCode", "0"),

    @JsonProperty("allow")
    ALLOW("allow", "1"),

    @JsonProperty("suppress")
    SUPPRESS("suppress", "2"),

    @JsonProperty("force")
    FORCE("force", "3");

    private final String name;
    private final String value;

    private Win32LobAppRestartBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
