package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Win32LobAppNotification implements Enum {

    @JsonProperty("showAll")
    SHOW_ALL("showAll", "0"),

    @JsonProperty("showReboot")
    SHOW_REBOOT("showReboot", "1"),

    @JsonProperty("hideAll")
    HIDE_ALL("hideAll", "2");

    private final String name;
    private final String value;

    private Win32LobAppNotification(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
