package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Win32LobAppFileSystemDetectionType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("exists")
    EXISTS("exists", "1"),

    @JsonProperty("modifiedDate")
    MODIFIED_DATE("modifiedDate", "2"),

    @JsonProperty("createdDate")
    CREATED_DATE("createdDate", "3"),

    @JsonProperty("version")
    VERSION("version", "4"),

    @JsonProperty("sizeInMB")
    SIZE_IN_MB("sizeInMB", "5"),

    @JsonProperty("doesNotExist")
    DOES_NOT_EXIST("doesNotExist", "6");

    private final String name;
    private final String value;

    private Win32LobAppFileSystemDetectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
