package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WiFiSecurityType implements Enum {

    @JsonProperty("open")
    OPEN("open", "0"),

    @JsonProperty("wpaPersonal")
    WPA_PERSONAL("wpaPersonal", "1"),

    @JsonProperty("wpaEnterprise")
    WPA_ENTERPRISE("wpaEnterprise", "2"),

    @JsonProperty("wep")
    WEP("wep", "3"),

    @JsonProperty("wpa2Personal")
    WPA2PERSONAL("wpa2Personal", "4"),

    @JsonProperty("wpa2Enterprise")
    WPA2ENTERPRISE("wpa2Enterprise", "5");

    private final String name;
    private final String value;

    private WiFiSecurityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
