package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WiFiProxySetting implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("manual")
    MANUAL("manual", "1"),

    @JsonProperty("automatic")
    AUTOMATIC("automatic", "2");

    private final String name;
    private final String value;

    private WiFiProxySetting(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
