package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WeeklySchedule implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("everyday")
    EVERYDAY("everyday", "1"),

    @JsonProperty("sunday")
    SUNDAY("sunday", "2"),

    @JsonProperty("monday")
    MONDAY("monday", "3"),

    @JsonProperty("tuesday")
    TUESDAY("tuesday", "4"),

    @JsonProperty("wednesday")
    WEDNESDAY("wednesday", "5"),

    @JsonProperty("thursday")
    THURSDAY("thursday", "6"),

    @JsonProperty("friday")
    FRIDAY("friday", "7"),

    @JsonProperty("saturday")
    SATURDAY("saturday", "8"),

    @JsonProperty("noScheduledScan")
    NO_SCHEDULED_SCAN("noScheduledScan", "9");

    private final String name;
    private final String value;

    private WeeklySchedule(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
