package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum VppTokenActionFailureReason implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("appleFailure")
    APPLE_FAILURE("appleFailure", "1"),

    @JsonProperty("internalError")
    INTERNAL_ERROR("internalError", "2"),

    @JsonProperty("expiredVppToken")
    EXPIRED_VPP_TOKEN("expiredVppToken", "3"),

    @JsonProperty("expiredApplePushNotificationCertificate")
    EXPIRED_APPLE_PUSH_NOTIFICATION_CERTIFICATE("expiredApplePushNotificationCertificate", "4");

    private final String name;
    private final String value;

    private VppTokenActionFailureReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
