package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum VppTokenAccountType implements Enum {

    @JsonProperty("business")
    BUSINESS("business", "0"),

    @JsonProperty("education")
    EDUCATION("education", "1");

    private final String name;
    private final String value;

    private VppTokenAccountType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
