package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum VpnTunnelConfigurationType implements Enum {

    @JsonProperty("wifiAndCellular")
    WIFI_AND_CELLULAR("wifiAndCellular", "0"),

    @JsonProperty("cellular")
    CELLULAR("cellular", "1"),

    @JsonProperty("wifi")
    WIFI("wifi", "2");

    private final String name;
    private final String value;

    private VpnTunnelConfigurationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
