package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum VpnIntegrityAlgorithmType implements Enum {

    @JsonProperty("sha2_256")
    SHA2_256("sha2_256", "0"),

    @JsonProperty("sha1_96")
    SHA1_96("sha1_96", "1"),

    @JsonProperty("sha1_160")
    SHA1_160("sha1_160", "2"),

    @JsonProperty("sha2_384")
    SHA2_384("sha2_384", "3"),

    @JsonProperty("sha2_512")
    SHA2_512("sha2_512", "4"),

    @JsonProperty("md5")
    MD5("md5", "5");

    private final String name;
    private final String value;

    private VpnIntegrityAlgorithmType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
