package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum VpnClientAuthenticationType implements Enum {

    @JsonProperty("userAuthentication")
    USER_AUTHENTICATION("userAuthentication", "0"),

    @JsonProperty("deviceAuthentication")
    DEVICE_AUTHENTICATION("deviceAuthentication", "1");

    private final String name;
    private final String value;

    private VpnClientAuthenticationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
