package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum VpnAuthenticationMethod implements Enum {

    @JsonProperty("certificate")
    CERTIFICATE("certificate", "0"),

    @JsonProperty("usernameAndPassword")
    USERNAME_AND_PASSWORD("usernameAndPassword", "1"),

    @JsonProperty("sharedSecret")
    SHARED_SECRET("sharedSecret", "2"),

    @JsonProperty("derivedCredential")
    DERIVED_CREDENTIAL("derivedCredential", "3"),

    @JsonProperty("azureAD")
    AZURE_AD("azureAD", "4");

    private final String name;
    private final String value;

    private VpnAuthenticationMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
