package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum VolumeType implements Enum {

    @JsonProperty("operatingSystemVolume")
    OPERATING_SYSTEM_VOLUME("operatingSystemVolume", "1"),

    @JsonProperty("fixedDataVolume")
    FIXED_DATA_VOLUME("fixedDataVolume", "2"),

    @JsonProperty("removableDataVolume")
    REMOVABLE_DATA_VOLUME("removableDataVolume", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private VolumeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
