package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UsernameSource implements Enum {

    @JsonProperty("userPrincipalName")
    USER_PRINCIPAL_NAME("userPrincipalName", "0"),

    @JsonProperty("primarySmtpAddress")
    PRIMARY_SMTP_ADDRESS("primarySmtpAddress", "1"),

    @JsonProperty("samAccountName")
    SAM_ACCOUNT_NAME("samAccountName", "2");

    private final String name;
    private final String value;

    private UsernameSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
