package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserPfxPaddingScheme implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("pkcs1")
    PKCS1("pkcs1", "1"),

    @JsonProperty("oaepSha1")
    OAEP_SHA1("oaepSha1", "2"),

    @JsonProperty("oaepSha256")
    OAEP_SHA256("oaepSha256", "3"),

    @JsonProperty("oaepSha384")
    OAEP_SHA384("oaepSha384", "4"),

    @JsonProperty("oaepSha512")
    OAEP_SHA512("oaepSha512", "5");

    private final String name;
    private final String value;

    private UserPfxPaddingScheme(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
