package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserNewMessageRestriction implements Enum {

    @JsonProperty("everyone")
    EVERYONE("everyone", "0"),

    @JsonProperty("everyoneExceptGuests")
    EVERYONE_EXCEPT_GUESTS("everyoneExceptGuests", "1"),

    @JsonProperty("moderators")
    MODERATORS("moderators", "2"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private UserNewMessageRestriction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
