package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserIdentityType implements Enum {

    @JsonProperty("aadUser")
    AAD_USER("aadUser", "0"),

    @JsonProperty("onPremiseAadUser")
    ON_PREMISE_AAD_USER("onPremiseAadUser", "1"),

    @JsonProperty("anonymousGuest")
    ANONYMOUS_GUEST("anonymousGuest", "2"),

    @JsonProperty("federatedUser")
    FEDERATED_USER("federatedUser", "3"),

    @JsonProperty("personalMicrosoftAccountUser")
    PERSONAL_MICROSOFT_ACCOUNT_USER("personalMicrosoftAccountUser", "4"),

    @JsonProperty("skypeUser")
    SKYPE_USER("skypeUser", "5");

    private final String name;
    private final String value;

    private UserIdentityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
