package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserFlowType implements Enum {

    @JsonProperty("signUp")
    SIGN_UP("signUp", "1"),

    @JsonProperty("signIn")
    SIGN_IN("signIn", "2"),

    @JsonProperty("signUpOrSignIn")
    SIGN_UP_OR_SIGN_IN("signUpOrSignIn", "3"),

    @JsonProperty("passwordReset")
    PASSWORD_RESET("passwordReset", "4"),

    @JsonProperty("profileUpdate")
    PROFILE_UPDATE("profileUpdate", "5"),

    @JsonProperty("resourceOwner")
    RESOURCE_OWNER("resourceOwner", "6"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private UserFlowType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
