package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserExperienceAnalyticsInsightSeverity implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("informational")
    INFORMATIONAL("informational", "1"),

    @JsonProperty("warning")
    WARNING("warning", "2"),

    @JsonProperty("error")
    ERROR("error", "3");

    private final String name;
    private final String value;

    private UserExperienceAnalyticsInsightSeverity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
