package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserExperienceAnalyticsHealthState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("insufficientData")
    INSUFFICIENT_DATA("insufficientData", "1"),

    @JsonProperty("needsAttention")
    NEEDS_ATTENTION("needsAttention", "2"),

    @JsonProperty("meetingGoals")
    MEETING_GOALS("meetingGoals", "3");

    private final String name;
    private final String value;

    private UserExperienceAnalyticsHealthState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
