package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UserEmailSource implements Enum {

    @JsonProperty("userPrincipalName")
    USER_PRINCIPAL_NAME("userPrincipalName", "0"),

    @JsonProperty("primarySmtpAddress")
    PRIMARY_SMTP_ADDRESS("primarySmtpAddress", "1");

    private final String name;
    private final String value;

    private UserEmailSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
