package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum UsageAuthMethod implements Enum {

    @JsonProperty("email")
    EMAIL("email", "0"),

    @JsonProperty("mobileSMS")
    MOBILE_SMS("mobileSMS", "1"),

    @JsonProperty("mobileCall")
    MOBILE_CALL("mobileCall", "2"),

    @JsonProperty("officePhone")
    OFFICE_PHONE("officePhone", "3"),

    @JsonProperty("securityQuestion")
    SECURITY_QUESTION("securityQuestion", "4"),

    @JsonProperty("appNotification")
    APP_NOTIFICATION("appNotification", "5"),

    @JsonProperty("appCode")
    APP_CODE("appCode", "6"),

    @JsonProperty("alternateMobileCall")
    ALTERNATE_MOBILE_CALL("alternateMobileCall", "7"),

    @JsonProperty("fido")
    FIDO("fido", "8"),

    @JsonProperty("appPassword")
    APP_PASSWORD("appPassword", "9"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "10");

    private final String name;
    private final String value;

    private UsageAuthMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
