package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Tone implements Enum {

    @JsonProperty("tone0")
    TONE0("tone0", "0"),

    @JsonProperty("tone1")
    TONE1("tone1", "1"),

    @JsonProperty("tone2")
    TONE2("tone2", "2"),

    @JsonProperty("tone3")
    TONE3("tone3", "3"),

    @JsonProperty("tone4")
    TONE4("tone4", "4"),

    @JsonProperty("tone5")
    TONE5("tone5", "5"),

    @JsonProperty("tone6")
    TONE6("tone6", "6"),

    @JsonProperty("tone7")
    TONE7("tone7", "7"),

    @JsonProperty("tone8")
    TONE8("tone8", "8"),

    @JsonProperty("tone9")
    TONE9("tone9", "9"),

    @JsonProperty("star")
    STAR("star", "10"),

    @JsonProperty("pound")
    POUND("pound", "11"),

    @JsonProperty("a")
    A("a", "12"),

    @JsonProperty("b")
    B("b", "13"),

    @JsonProperty("c")
    C("c", "14"),

    @JsonProperty("d")
    D("d", "15"),

    @JsonProperty("flash")
    FLASH("flash", "16");

    private final String name;
    private final String value;

    private Tone(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
