package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ThreatAssessmentRequestSource implements Enum {

    @JsonProperty("undefined")
    UNDEFINED("undefined", "0"),

    @JsonProperty("user")
    USER("user", "1"),

    @JsonProperty("administrator")
    ADMINISTRATOR("administrator", "2");

    private final String name;
    private final String value;

    private ThreatAssessmentRequestSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
