package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ThreatAssessmentRequestPivotProperty implements Enum {

    @JsonProperty("threatCategory")
    THREAT_CATEGORY("threatCategory", "1"),

    @JsonProperty("mailDestinationRoutingReason")
    MAIL_DESTINATION_ROUTING_REASON("mailDestinationRoutingReason", "2");

    private final String name;
    private final String value;

    private ThreatAssessmentRequestPivotProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
