package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TeamsAsyncOperationType implements Enum {

    @JsonProperty("invalid")
    INVALID("invalid", "0"),

    @JsonProperty("cloneTeam")
    CLONE_TEAM("cloneTeam", "1"),

    @JsonProperty("archiveTeam")
    ARCHIVE_TEAM("archiveTeam", "2"),

    @JsonProperty("unarchiveTeam")
    UNARCHIVE_TEAM("unarchiveTeam", "3"),

    @JsonProperty("createTeam")
    CREATE_TEAM("createTeam", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private TeamsAsyncOperationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
