package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TeamsAsyncOperationStatus implements Enum {

    @JsonProperty("invalid")
    INVALID("invalid", "0"),

    @JsonProperty("notStarted")
    NOT_STARTED("notStarted", "1"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "2"),

    @JsonProperty("succeeded")
    SUCCEEDED("succeeded", "3"),

    @JsonProperty("failed")
    FAILED("failed", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private TeamsAsyncOperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
