package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TaskStatus implements Enum {

    @JsonProperty("notStarted")
    NOT_STARTED("notStarted", "0"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "1"),

    @JsonProperty("completed")
    COMPLETED("completed", "2"),

    @JsonProperty("waitingOnOthers")
    WAITING_ON_OTHERS("waitingOnOthers", "3"),

    @JsonProperty("deferred")
    DEFERRED("deferred", "4");

    private final String name;
    private final String value;

    private TaskStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
