package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SynchronizationStatusCode implements Enum {

    @JsonProperty("NotConfigured")
    NOT_CONFIGURED("NotConfigured", "0"),

    @JsonProperty("NotRun")
    NOT_RUN("NotRun", "1"),

    @JsonProperty("Active")
    ACTIVE("Active", "2"),

    @JsonProperty("Paused")
    PAUSED("Paused", "3"),

    @JsonProperty("Quarantine")
    QUARANTINE("Quarantine", "4");

    private final String name;
    private final String value;

    private SynchronizationStatusCode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
