package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SynchronizationScheduleState implements Enum {

    @JsonProperty("Active")
    ACTIVE("Active", "0"),

    @JsonProperty("Disabled")
    DISABLED("Disabled", "1"),

    @JsonProperty("Paused")
    PAUSED("Paused", "2");

    private final String name;
    private final String value;

    private SynchronizationScheduleState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
