package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SynchronizationJobRestartScope implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("ConnectorDataStore")
    CONNECTOR_DATA_STORE("ConnectorDataStore", "1"),

    @JsonProperty("Escrows")
    ESCROWS("Escrows", "2"),

    @JsonProperty("Watermark")
    WATERMARK("Watermark", "4"),

    @JsonProperty("QuarantineState")
    QUARANTINE_STATE("QuarantineState", "8"),

    @JsonProperty("Full")
    FULL("Full", "15"),

    @JsonProperty("ForceDeletes")
    FORCE_DELETES("ForceDeletes", "32");

    private final String name;
    private final String value;

    private SynchronizationJobRestartScope(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
