package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SubjectNameFormat implements Enum {

    @JsonProperty("commonName")
    COMMON_NAME("commonName", "0"),

    @JsonProperty("commonNameIncludingEmail")
    COMMON_NAME_INCLUDING_EMAIL("commonNameIncludingEmail", "1"),

    @JsonProperty("commonNameAsEmail")
    COMMON_NAME_AS_EMAIL("commonNameAsEmail", "2"),

    @JsonProperty("custom")
    CUSTOM("custom", "3"),

    @JsonProperty("commonNameAsIMEI")
    COMMON_NAME_AS_IMEI("commonNameAsIMEI", "5"),

    @JsonProperty("commonNameAsSerialNumber")
    COMMON_NAME_AS_SERIAL_NUMBER("commonNameAsSerialNumber", "6"),

    @JsonProperty("commonNameAsAadDeviceId")
    COMMON_NAME_AS_AAD_DEVICE_ID("commonNameAsAadDeviceId", "7"),

    @JsonProperty("commonNameAsIntuneDeviceId")
    COMMON_NAME_AS_INTUNE_DEVICE_ID("commonNameAsIntuneDeviceId", "8"),

    @JsonProperty("commonNameAsDurableDeviceId")
    COMMON_NAME_AS_DURABLE_DEVICE_ID("commonNameAsDurableDeviceId", "9");

    private final String name;
    private final String value;

    private SubjectNameFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
