package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Status implements Enum {

    @JsonProperty("active")
    ACTIVE("active", "0"),

    @JsonProperty("updated")
    UPDATED("updated", "1"),

    @JsonProperty("deleted")
    DELETED("deleted", "2"),

    @JsonProperty("ignored")
    IGNORED("ignored", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private Status(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
