package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum StagedFeatureName implements Enum {

    @JsonProperty("passthroughAuthentication")
    PASSTHROUGH_AUTHENTICATION("passthroughAuthentication", "0"),

    @JsonProperty("seamlessSso")
    SEAMLESS_SSO("seamlessSso", "1"),

    @JsonProperty("passwordHashSync")
    PASSWORD_HASH_SYNC("passwordHashSync", "2"),

    @JsonProperty("emailAsAlternateId")
    EMAIL_AS_ALTERNATE_ID("emailAsAlternateId", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private StagedFeatureName(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
