package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SkillProficiencyLevel implements Enum {

    @JsonProperty("elementary")
    ELEMENTARY("elementary", "0"),

    @JsonProperty("limitedWorking")
    LIMITED_WORKING("limitedWorking", "1"),

    @JsonProperty("generalProfessional")
    GENERAL_PROFESSIONAL("generalProfessional", "2"),

    @JsonProperty("advancedProfessional")
    ADVANCED_PROFESSIONAL("advancedProfessional", "3"),

    @JsonProperty("expert")
    EXPERT("expert", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private SkillProficiencyLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
