package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SiteSecurityLevel implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("low")
    LOW("low", "1"),

    @JsonProperty("mediumLow")
    MEDIUM_LOW("mediumLow", "2"),

    @JsonProperty("medium")
    MEDIUM("medium", "3"),

    @JsonProperty("mediumHigh")
    MEDIUM_HIGH("mediumHigh", "4"),

    @JsonProperty("high")
    HIGH("high", "5");

    private final String name;
    private final String value;

    private SiteSecurityLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
