package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SiteAccessType implements Enum {

    @JsonProperty("block")
    BLOCK("block", "0"),

    @JsonProperty("full")
    FULL("full", "1"),

    @JsonProperty("limited")
    LIMITED("limited", "2");

    private final String name;
    private final String value;

    private SiteAccessType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
