package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SingleSignOnMode implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("onPremisesKerberos")
    ON_PREMISES_KERBEROS("onPremisesKerberos", "1"),

    @JsonProperty("saml")
    SAML("saml", "3");

    private final String name;
    private final String value;

    private SingleSignOnMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
