package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SigninFrequencyType implements Enum {

    @JsonProperty("days")
    DAYS("days", "0"),

    @JsonProperty("hours")
    HOURS("hours", "1");

    private final String name;
    private final String value;

    private SigninFrequencyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
