package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SharedPCAccountDeletionPolicyType implements Enum {

    @JsonProperty("immediate")
    IMMEDIATE("immediate", "0"),

    @JsonProperty("diskSpaceThreshold")
    DISK_SPACE_THRESHOLD("diskSpaceThreshold", "1"),

    @JsonProperty("diskSpaceThresholdOrInactiveThreshold")
    DISK_SPACE_THRESHOLD_OR_INACTIVE_THRESHOLD("diskSpaceThresholdOrInactiveThreshold", "2");

    private final String name;
    private final String value;

    private SharedPCAccountDeletionPolicyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
