package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SetupStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("notRegisteredYet")
    NOT_REGISTERED_YET("notRegisteredYet", "1"),

    @JsonProperty("registeredSetupNotStarted")
    REGISTERED_SETUP_NOT_STARTED("registeredSetupNotStarted", "2"),

    @JsonProperty("registeredSetupInProgress")
    REGISTERED_SETUP_IN_PROGRESS("registeredSetupInProgress", "3"),

    @JsonProperty("registrationAndSetupCompleted")
    REGISTRATION_AND_SETUP_COMPLETED("registrationAndSetupCompleted", "4"),

    @JsonProperty("registrationFailed")
    REGISTRATION_FAILED("registrationFailed", "5"),

    @JsonProperty("registrationTimedOut")
    REGISTRATION_TIMED_OUT("registrationTimedOut", "6"),

    @JsonProperty("disabled")
    DISABLED("disabled", "7");

    private final String name;
    private final String value;

    private SetupStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
