package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SensitivityLabelTarget implements Enum {

    @JsonProperty("email")
    EMAIL("email", "1"),

    @JsonProperty("site")
    SITE("site", "2"),

    @JsonProperty("unifiedGroup")
    UNIFIED_GROUP("unifiedGroup", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private SensitivityLabelTarget(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
