package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Sensitivity implements Enum {

    @JsonProperty("normal")
    NORMAL("normal", "0"),

    @JsonProperty("personal")
    PERSONAL("personal", "1"),

    @JsonProperty("private")
    PRIVATE("private", "2"),

    @JsonProperty("confidential")
    CONFIDENTIAL("confidential", "3");

    private final String name;
    private final String value;

    private Sensitivity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
