package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SecurityQuestionType implements Enum {

    @JsonProperty("predefined")
    PREDEFINED("predefined", "0"),

    @JsonProperty("custom")
    CUSTOM("custom", "1");

    private final String name;
    private final String value;

    private SecurityQuestionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
