package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SecurityNetworkProtocol implements Enum {

    @JsonProperty("ip")
    IP("ip", "0"),

    @JsonProperty("icmp")
    ICMP("icmp", "1"),

    @JsonProperty("igmp")
    IGMP("igmp", "2"),

    @JsonProperty("ggp")
    GGP("ggp", "3"),

    @JsonProperty("ipv4")
    IPV4("ipv4", "4"),

    @JsonProperty("tcp")
    TCP("tcp", "6"),

    @JsonProperty("pup")
    PUP("pup", "12"),

    @JsonProperty("udp")
    UDP("udp", "17"),

    @JsonProperty("idp")
    IDP("idp", "22"),

    @JsonProperty("ipv6")
    IPV6("ipv6", "41"),

    @JsonProperty("ipv6RoutingHeader")
    IPV6ROUTING_HEADER("ipv6RoutingHeader", "43"),

    @JsonProperty("ipv6FragmentHeader")
    IPV6FRAGMENT_HEADER("ipv6FragmentHeader", "44"),

    @JsonProperty("ipSecEncapsulatingSecurityPayload")
    IP_SEC_ENCAPSULATING_SECURITY_PAYLOAD("ipSecEncapsulatingSecurityPayload", "50"),

    @JsonProperty("ipSecAuthenticationHeader")
    IP_SEC_AUTHENTICATION_HEADER("ipSecAuthenticationHeader", "51"),

    @JsonProperty("icmpV6")
    ICMP_V6("icmpV6", "58"),

    @JsonProperty("ipv6NoNextHeader")
    IPV6NO_NEXT_HEADER("ipv6NoNextHeader", "59"),

    @JsonProperty("ipv6DestinationOptions")
    IPV6DESTINATION_OPTIONS("ipv6DestinationOptions", "60"),

    @JsonProperty("nd")
    ND("nd", "77"),

    @JsonProperty("raw")
    RAW("raw", "255"),

    @JsonProperty("ipx")
    IPX("ipx", "1000"),

    @JsonProperty("spx")
    SPX("spx", "1256"),

    @JsonProperty("spxII")
    SPX_II("spxII", "1257"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "32767"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "-1");

    private final String name;
    private final String value;

    private SecurityNetworkProtocol(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
