package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SecurityBaselineComplianceState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("secure")
    SECURE("secure", "1"),

    @JsonProperty("notApplicable")
    NOT_APPLICABLE("notApplicable", "2"),

    @JsonProperty("notSecure")
    NOT_SECURE("notSecure", "3"),

    @JsonProperty("error")
    ERROR("error", "4"),

    @JsonProperty("conflict")
    CONFLICT("conflict", "5");

    private final String name;
    private final String value;

    private SecurityBaselineComplianceState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
