package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SecureBootWithDMAType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("withoutDMA")
    WITHOUT_DMA("withoutDMA", "1"),

    @JsonProperty("withDMA")
    WITH_DMA("withDMA", "3");

    private final String name;
    private final String value;

    private SecureBootWithDMAType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
