package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SecureAssessmentAccountType implements Enum {

    @JsonProperty("azureADAccount")
    AZURE_ADACCOUNT("azureADAccount", "0"),

    @JsonProperty("domainAccount")
    DOMAIN_ACCOUNT("domainAccount", "1"),

    @JsonProperty("localAccount")
    LOCAL_ACCOUNT("localAccount", "2"),

    @JsonProperty("localGuestAccount")
    LOCAL_GUEST_ACCOUNT("localGuestAccount", "3");

    private final String name;
    private final String value;

    private SecureAssessmentAccountType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
