package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ScopeOperatorType implements Enum {

    @JsonProperty("Binary")
    BINARY("Binary", "0"),

    @JsonProperty("Unary")
    UNARY("Unary", "1");

    private final String name;
    private final String value;

    private ScopeOperatorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
