package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RunState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("success")
    SUCCESS("success", "1"),

    @JsonProperty("fail")
    FAIL("fail", "2"),

    @JsonProperty("scriptError")
    SCRIPT_ERROR("scriptError", "3"),

    @JsonProperty("pending")
    PENDING("pending", "4"),

    @JsonProperty("notApplicable")
    NOT_APPLICABLE("notApplicable", "5");

    private final String name;
    private final String value;

    private RunState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
